﻿namespace Microsoft.Samples.PlanMyNight.Data
{
    using System;
    using System.Collections.Generic;
    using Microsoft.Samples.PlanMyNight.Entities;

    public interface IActivitiesRepository
    {
        Activity RetrieveActivity(string id);

        PagingResult<Activity> Search(AdvancedSearchQuery searchCriteria);

        PagingResult<Activity> Search(NaturalSearchQuery query);

        Tuple<double, double> GeocodeAddress(ActivityAddress address);

        ActivityAddress ParseQueryLocation(string query);

        IEnumerable<ActivityType> RetrieveActivityTypes();

        void PopulateItineraryActivities(Itinerary itinerary);
    }
}
